#include <stdio.h>
#include <time.h>

#include "../common/objects.h"
#include "../common/debug.h"
//#include "./shading/shaders.h"
#include "ray_generator.h"
#include "../common/vector.h"
#include "tracer.h"

extern scene_data* main_scene;
#define CAMERA1 main_scene->camera
/******************************************
 * generate the rays from the camera
 *******************************************/
void generate_rays()
{
	char* ptr;
	int i, j;
	int hit_id = -1;
	double ratio_x, ratio_y;
	double red, green, blue;
	double percent = 0, percentOld = 0;

	vector projection;
	point intersectP;
	color pixelColor;
	pixelColor.r = 0;
	pixelColor.g = 0;
	pixelColor.b = 0;

	ptr = (char*) (&main_scene->frame_buffer[0]);

	/* trace the scene and record results */
	printd(1, "entering render loop\n");
	printf("\n |                       50                       |\n ");

/****************************************************************************
   this renders the frame right-side up
   for(j=0; j<height; j++)

   the loop below renders upside down
   ***switched!!!***
   for(j=main_scene->height; j>0; j--) 
*****************************************************************************/
   for(j=0; j<main_scene->height; j++)
   {
		for(i=0; i<main_scene->width; i++)
		{
			ratio_y = j*main_scene->stretch_y - main_scene->cons_y;
			ratio_x = i*main_scene->stretch_x - main_scene->cons_x;
			projection.x = CAMERA1->look.x + ratio_x*CAMERA1->horz.x +
				ratio_y*CAMERA1->vert.x;
			projection.y = CAMERA1->look.y + ratio_x*CAMERA1->horz.y +
				ratio_y*CAMERA1->vert.y;
			projection.z = CAMERA1->look.z + ratio_x*CAMERA1->horz.z +
				ratio_y*CAMERA1->vert.z;

			printd(CRAZY, "tracing: %i, %i\n", i, j);
			hit_id = trace(&CAMERA1->pos,&intersectP, &projection,0);

			if(hit_id == BACKGROUND)
			{
			   red = main_scene->background->amb.r;
			   green = main_scene->background->amb.g;
			   blue = main_scene->background->amb.b;
			}
			else
			{
				#ifdef TESTING
				red = (hit_id+1)*80;
				green = (hit_id+1)*20;
				blue = (hit_id+1)*40;
				#else
				normalize(&projection);
				//shaders_lighting(&CAMERA1->pos,&intersectP,&projection,1,&pixelColor,hit_id);
				//FIXME: shading is OFF ^^^
				red=pixelColor.r;
				green=pixelColor.g;
				blue=pixelColor.b;
				#endif
			}

			if (red > 255)
				red = 255;
			if (green > 255)
				green = 255;
			if (blue > 255)
				blue = 255;

			*ptr = (char)red;
			ptr++;
			*ptr = (char)green;
			ptr++;
			*ptr = (char)blue;
			ptr++;
			//printd(3, ":: %f, %f, %f\n", red, green, blue);
			printd(CRAZY, "writing colors: %i %i %i\n",
					(char)red, (char)green, (char)blue);
		}
		
		percent = (main_scene->height - j)/(double)(2*main_scene->height)*100;
		//fprintf(stdout, "%f\n", percent - percentOld);
		if(percent - percentOld > 1)
		{
			for(i = 0; i < (int)(percent - percentOld); i++)
			printf("#");
			fflush(stdout);
			percentOld = percent;
		}

   }
   
	while(percentOld < 51)
	{
		printf("#");
		fflush(stdout);
		percentOld += 1;
	}
	printf("\n\n");
}
